/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

appModule.controller('OverlayController', ['$scope', 'Utils', function ($scope, Utils) {
    var self = this;
    Utils.overlayCtrl = this;

    self.isOverlayShown = false;

    self.alertTitle = '';
    self.showAlertIcon = false;
    self.alertText = '';
    self.showTwoButtons = true;
    self.leftButtonText = '';
    self.rightButtonText = '';

    self.alertRightButtonHandler = null;
    self.alertLeftButtonHandler = null;

    self.removeBlurEffect = function () {
        Utils.removeClass(document.getElementById("mainScreen"), "blurredClass");
        Utils.removeClass(document.getElementById("marketingIFrameDiv"), "blurredClass");
        Utils.removeClass(document.getElementById("progressTrack"), "dimClass");
    };

    self.addBlurEffect = function () {
        Utils.addClass(document.getElementById("mainScreen"), "blurredClass");
        Utils.addClass(document.getElementById("marketingIFrameDiv"), "blurredClass");
        Utils.addClass(document.getElementById("progressTrack"), "dimClass");
    };

    self.alertLeftButtonClicked = function () {
        var clearHandlers = true;
        if (self.alertLeftButtonHandler)
            clearHandlers = self.alertLeftButtonHandler();
        if (clearHandlers == undefined || clearHandlers) {
            self.alertRightButtonHandler = null;
            self.alertLeftButtonHandler = null;
        }
    };

    self.alertRightButtonClicked = function () {
        var clearHandlers = true;
        if (self.alertRightButtonHandler)
            clearHandlers = self.alertRightButtonHandler();
        if (clearHandlers == undefined || clearHandlers) {
            self.alertRightButtonHandler = null;
            self.alertLeftButtonHandler = null;
        }
    };

    self.hideOverlay = function () {
        sendMessageToNative("overrideCrossButtonState", "false");
        Utils.mainCtrl.isInErrorState = false;

        self.removeBlurEffect();
        $("#overlayScreen").fadeOut(200);
        self.isOverlayShown = false;
    };

    self.popUpShownOnce = false;
    self.showOverlayAlert = function () {
        sendMessageToNative("overrideCrossButtonState", "true");
        Utils.getElemById("alertText").innerHTML = self.alertText;
     
        self.isOverlayShown = true;

      
        $("#overlayScreen").fadeIn(200, function () {
            // Animation complete
            $(".viewport").height("");
            if ($(".scroll-bar.vertical").is(":visible") && self.popUpShownOnce == true) {
                $(".modalBody").customScrollbar("remove");
            } else {
                $(".modalBody").customScrollbar();
                self.popUpShownOnce = true;
            }

            $(".modalBody").customScrollbar();

            /*check overflow to add border*/
            if ($(".scroll-bar.vertical").is(":visible")) {
                Utils.getElemById("modalFooter").className = "modalFooter text-center";
            } else {
                Utils.getElemById("modalFooter").className = "modalFooter text-center noBorder";
            }
        });
        self.addBlurEffect();
    };

    //Quit confirmation
    self.quitConfirmationNoClicked = function () {
        self.hideOverlay();
        sendMessageToNative("quitConfirmationNoClicked", "");
    };

    self.quitConfirmationYesClicked = function () {
        self.hideOverlay();
        Utils.mainCtrl.showQuittingScreen();
        sendMessageToNative("quitConfirmationYesClicked", "");
    };

    self.showQuitConfirmation = function (screenData) {
        self.alertTitle = Utils.getLocalizedString("QuitConfirmTitle");
        self.showAlertIcon = false;
        self.alertText = Utils.getLocalizedString("QuitConfirm").replace('{0}', Utils.mainCtrl.applicationName);
        self.showTwoButtons = true;
        self.leftButtonText = Utils.getLocalizedString("Quit");
        self.rightButtonText = Utils.getLocalizedString("DontQuit");

        self.alertLeftButtonHandler = self.quitConfirmationYesClicked;
        self.alertRightButtonHandler = self.quitConfirmationNoClicked;
        if (!(screenData == undefined || screenData == null) && "isMessageFromNative" in screenData && screenData["isMessageFromNative"] == "true")
        {
            //isMessageFromNative is true when quitConfirmation message is sent from Native
            $scope.$apply(function () {
                self.showOverlayAlert();
            });
        }
        else {
            self.showOverlayAlert();
        }
       
    };

    //Error Alert
    self.retryClicked = function () {
        self.hideOverlay();
        sendMessageToNative("retryClicked", "");
    };

    self.retyableErrorQuitClicked = function () {
        self.showQuitConfirmation();
        self.alertRightButtonHandler = self.retryClicked;
        return false;
    };

    self.showErrorAlert = function (alertData) {
        Utils.mainCtrl.isInErrorState = true;
        if (alertData.showOpen == "true" || alertData.showRetry == "true" || alertData.showContinue == "true" || alertData.showYes == "true") {
            if (alertData.errorTitle != "")
                self.alertTitle = Utils.getLocalizedString(alertData.errorTitle, Utils.mainCtrl.applicationName);
            else
                self.alertTitle = Utils.getLocalizedString("RetryInstallationTitle");
            self.showTwoButtons = true;
			self.leftButtonText = Utils.getLocalizedString("Quit");
			self.alertRightButtonHandler = self.retryClicked;
            self.alertLeftButtonHandler = self.retyableErrorQuitClicked;
			
            if (alertData.showOpen && alertData.showOpen == "true") {
                self.rightButtonText = Utils.getLocalizedString("Open", Utils.mainCtrl.applicationName);
            }else if (alertData.showRetry && alertData.showRetry == "true") {
                self.rightButtonText = Utils.getLocalizedString("Retry");	
            }else if (alertData.showYes && alertData.showYes == "true") {
		        self.rightButtonText = Utils.getLocalizedString("Yes");
		    }else {
                self.rightButtonText = Utils.getLocalizedString("Continue");
            }
            
        } else {
            if (alertData.errorTitle != "")
                self.alertTitle = Utils.getLocalizedString(alertData.errorTitle);
            else
                self.alertTitle = Utils.getLocalizedString("InstallationFailedTitle");

            self.showTwoButtons = false;
            self.rightButtonText = Utils.getLocalizedString("Quit");
            self.alertRightButtonHandler = self.quitConfirmationYesClicked;
        }
        self.alertText = Utils.getLocalizedString(alertData.errorType);
        self.alertText = self.alertText.replace('{AppName}', Utils.mainCtrl.applicationName);
        if (self.alertText.indexOf('{10}') > -1) {
           var urlForOpening;
           if("STG" === Utils.mainCtrl.environment || "STAGE" === Utils.mainCtrl.environment)
                urlForOpening = Utils.getLocalizedString("CustomerSupportStageLink");
           else
                urlForOpening = Utils.getLocalizedString("CustomerSupportLink");
            self.alertText = self.alertText.replace('{10}', "<a ondragstart='return false;' onclick='openUrl(event,false)' target='_blank' href='" + urlForOpening + "'>");
        } else if (self.alertText.indexOf('{12}') > -1) {
			
			var urlForOpening = '';
			urlForOpening = alertData.systemRequirementURL;
			if (urlForOpening == '' || urlForOpening == null || urlForOpening == undefined) {
                   if("STG" === Utils.mainCtrl.environment || "STAGE" === Utils.mainCtrl.environment)
                        urlForOpening = Utils.getLocalizedString("MinSysReqStageLink");
                   else
                        urlForOpening = Utils.getLocalizedString("MinSysReqLink");
			}
            self.alertText = self.alertText.replace('{12}', "<a ondragstart='return false;' onclick='openUrl(event,false)' target='_blank' href='" + urlForOpening + "'>");
        } else if (self.alertText.indexOf('{13}') > -1) {
           if("STG" === Utils.mainCtrl.environment || "STAGE" === Utils.mainCtrl.environment)
                urlForOpening = Utils.getLocalizedString("DllMissingKbArticleStageLink");
           else
                urlForOpening = Utils.getLocalizedString("DllMissingKbArticleLink");
            self.alertText = self.alertText.replace('{13}', "<a ondragstart='return false;' onclick='openUrl(event,false)' target='_blank' href='" + urlForOpening + "'>");
        } else if (self.alertText.indexOf('{16}') > -1) {
            self.alertText = self.alertText.replace('{16}', "<a ondragstart='return false;' onclick='openUrl(event,false)' target='_blank' href='" + alertData.errorParam + "'>"+alertData.errorParam+"</a>");
        }
        self.alertText = self.alertText.replace('{11}', "</a>");
        if (alertData.errorParam) {
            if (alertData.appendParamsAtEnd && alertData.appendParamsAtEnd == "true")
                self.alertText += alertData.errorParam;
            else
                self.alertText = self.alertText.replace('{0}', alertData.errorParam);
        }
        if (alertData.errorCode) {
            self.alertText = self.alertText + ' ' + Utils.getLocalizedString('ErrorCode').replace('{0}', alertData.errorCode);
        }
        if (alertData.moreInfoLink) {
            var fileLinkForOpening = alertData.moreInfoLink;
            self.alertText = self.alertText + ' ' + "<a ondragstart='return false;' onclick='openFile(event)' target='_blank' href='" + fileLinkForOpening + "'>" + Utils.getLocalizedString("MoreInfo") + "</a>";
        }
        $scope.$apply(function () {
            self.showOverlayAlert();
        });
    };

    //Path Error Alert
    self.pathResponseData = "";

    self.showPathErrorAlert = function (alertData) {
        Utils.mainCtrl.isInErrorState = true;
        self.pathResponseData = "";

        self.alertTitle = Utils.getLocalizedString(alertData.alertTitle);
        self.showAlertIcon = true;
        self.alertText = Utils.getLocalizedString(alertData.alertText);

        if (alertData.errorParam) {
            self.alertText = self.alertText.replace('{0}', alertData.errorParam);
        }

        if (alertData.installLocation != undefined) {
            self.pathResponseData = "{";
            self.pathResponseData += '"alertTitle":"' + alertData.alertTitle + '",';
            self.pathResponseData += '"alertText":"' + alertData.alertText + '",';
            if (alertData.errorParam)
                self.pathResponseData += '"errorParam":"' + alertData.errorParam + '"';
            else
                self.pathResponseData += '"errorParam":""';
            self.pathResponseData += "}";

            var stringLocation = "<br>";
            stringLocation += "<a ondragstart='return false;' style='color:#1473e6' ";
            stringLocation += "onclick='locationChangeLinkClicked(event)' target='_blank' href='#'>";
            if (alertData.installLocation === "")
                stringLocation += Utils.getLocalizedString("InstallLocationDefault");
            else
                stringLocation += alertData.installLocation;
            stringLocation += " (<span style='color:#1473e6'>" + Utils.getLocalizedString("ChangeSmall") + "</span>)" + "</a>";
            var locationStr = Utils.getLocalizedString("InstallLocation");
            locationStr = locationStr.replace('{0}', stringLocation);
            self.alertText = self.alertText + "<br><br>" + locationStr;
        }

        self.showTwoButtons = true;
        self.leftButtonText = Utils.getLocalizedString("Quit");
        self.rightButtonText = Utils.getLocalizedString("Retry");

        self.alertLeftButtonHandler = self.quitConfirmationYesClicked;
        self.alertRightButtonHandler = function () {
            self.hideOverlay();
            sendMessageToNative("locationRetryClicked", "");
        };

        $scope.$apply(function () {
            self.showOverlayAlert();
        });
    };

    self.showCompatibilityErrorAlert = function (alertData) {
        Utils.mainCtrl.isInErrorState = true;
        self.alertTitle = Utils.getLocalizedString("CompatibilityErrorAlertTitle");

        if (alertData.checkResult == "fail")
        {
            self.showTwoButtons = false;

            self.rightButtonText = Utils.getLocalizedString("Quit");
            self.alertRightButtonHandler = self.quitConfirmationYesClicked;
        }
        else if (alertData.checkResult == "warn")
        {
            self.showTwoButtons = true;
            self.rightButtonText = Utils.getLocalizedString("Retry");
            self.leftButtonText = Utils.getLocalizedString("Quit");
            self.alertRightButtonHandler = self.retryClicked;
            self.alertLeftButtonHandler = self.quitConfirmationYesClicked;

        }
        var urlForOpening = alertData.systemRequirementURL;
        var alertText = Utils.getLocalizedString('CompatibilityErrorAlertHeader').replace('{0}', Utils.mainCtrl.applicationName);
        alertText += "<br><br>"; //Header
        for ( var i = 0; i < alertData.failingList.length; i++)
        {
            var type = alertData.failingList[i].type;
            var message = alertData.failingList[i].message;
            alertText += "- ";
            alertText += message;
            alertText += " <br>";
        }
        alertText += "<br>";
        alertText += Utils.getLocalizedString('CompatibilityErrorAlertFooter').replace('{10}', "<a ondragstart='return false;' onclick='openUrl(event,false)' target='_blank' href='" + urlForOpening + "'>");
        alertText = alertText.replace('{11}', "</a>"); //Footer
        self.alertText = alertText;
        $scope.$apply(function () {
            self.showOverlayAlert();
        });

    };

    //Proxy Screen
    self.isProxyAlertShownOnce = false;
    self.rememberProxy = true;

    self.showProxyAlert = function (screenData) {
        self.showAlertIcon = self.isProxyAlertShownOnce;
        self.isProxyAlertShownOnce = true;

        if (self.showAlertIcon)
        {
            Utils.addClass(document.getElementById("proxyAlertUsername"), "errorTextbox");
            Utils.addClass(document.getElementById("proxyAlertPassword"), "errorTextbox");
        }

        self.alertTitle = Utils.getLocalizedString("ProxyAlertHeader");
        self.alertText = "";

        self.showTwoButtons = true;
        self.rightButtonText = Utils.getLocalizedString("Continue");
        self.leftButtonText = Utils.getLocalizedString("Quit");
        self.alertRightButtonHandler = self.proxyAlertLoginButtonClick;
        self.alertLeftButtonHandler = self.quitConfirmationYesClicked;

        $scope.$apply(function () {
            self.showOverlayAlert();
        });

        $('input').placeholder({
            customClass: 'userInputBlank'
        });
    };

    self.proxyAlertLoginButtonClick = function () {
        self.hideOverlay();

        var details = {};
        details["userName"] = $("#proxyAlertUsername").val();
        details["password"] = $("#proxyAlertPassword").val();
        details["rememberMe"] = self.rememberProxy?"true":"false";
        sendMessageToNative("proxyAlertLoginButtonClicked", JSON.stringify(details));
    };

}]);
